% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_brainGraph_attributes.R
\name{set_brainGraph_attr}
\alias{set_brainGraph_attr}
\alias{set.brainGraph.attributes}
\title{Set graph, vertex, and edge attributes common in MRI analyses}
\usage{
set_brainGraph_attr(g, atlas = NULL, modality = NULL, subject = NULL,
  group = NULL, rand = FALSE, use.parallel = TRUE, A = NULL)

set.brainGraph.attributes(g, atlas = NULL, modality = NULL,
  subject = NULL, group = NULL, rand = FALSE, use.parallel = TRUE)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{atlas}{Character vector indicating which atlas was used (default:
\code{NULL})}

\item{modality}{Character vector indicating imaging modality (e.g. 'dti')
(default: \code{NULL})}

\item{subject}{Character vector indicating subject ID (default: \code{NULL})}

\item{group}{Character vector indicating group membership (default: NULL)}

\item{rand}{Logical indicating if the graph is random or not (default: FALSE)}

\item{use.parallel}{Logical indicating whether or not to use \emph{foreach}
(default: TRUE)}

\item{A}{Numeric matrix; the (weighted) adjacency matrix, which can be used
for faster calculation of local efficiency (default: \code{NULL})}
}
\value{
g An \code{igraph} graph object with the following attributes:
\item{Graph-level}{Package version, atlas, density, connected component sizes,
diameter, \# of triangles, transitivity, average path length, assortativity,
clique number, global & local efficiency, modularity, vulnerability, hub score,
rich-club coefficient, \# of hubs, edge asymmetry, and modality}
\item{Vertex-level}{Degree, strength, betweenness/eigenvector and leverage
centralities, hubs, transitivity (local), coreness, local & nodal efficiency,
color (community), color (lobe), color (component), membership (community),
membership (component), gateway and participation coefficients, within-module
degree z-score, vulnerability, and coordinates (x, y, and z)}
\item{Edge-level}{Color (community), color (lobe), color (component), edge
betweenness, Euclidean distance (in mm)}
}
\description{
This function sets a number of graph, vertex, and edge attributes for a
given \code{igraph} graph object. These are all measures that are common in
MRI analyses of brain networks.
}
\seealso{
\code{\link[igraph]{components}, \link[igraph]{diameter},
\link[igraph]{clique_num}, \link[igraph]{centr_betw}, \link{part_coeff},
\link[igraph]{edge.betweenness}, \link[igraph]{centr_eigen},
\link{gateway_coeff}, \link[igraph]{hub.score},
\link[igraph]{authority.score}, \link[igraph]{transitivity},
\link[igraph]{mean_distance}, \link[igraph]{assortativity.degree},
\link[igraph]{cluster_louvain}, \link{efficiency},
\link{set_edge_color}, \link{rich_club_coeff},
\link{within_module_deg_z_score}, \link[igraph]{coreness},
\link{edge_spatial_dist}, \link{vulnerability}, \link{centr_lev},
\link{edge_asymmetry}, \link[igraph]{graph.knn}, \link{vertex_spatial_dist}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
