% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa_trans.R
\name{kappa_trans}
\alias{kappa_trans}
\alias{scale_x_kappa}
\alias{scale_y_kappa}
\title{BRAID kappa Transforms}
\usage{
kappa_trans()

scale_x_kappa(...)

scale_y_kappa(...)
}
\arguments{
\item{...}{Additional parameter to be passed to \verb{scale_*_continuous}}
}
\value{
For \code{kappa_trans} a \code{scales} transform object.  For \verb{scale_*_kappa},
a continuous position scale layer for a ggplot object.
}
\description{
Functions to linearize the BRAID interaction parameter kappa, which ordinarily
ranges from -2 to infinity. \code{kappa_trans} produces a \code{scales} transform
object which can be used in \code{ggplot2} continuous scale object.
\code{scale_x_kappa} and \code{scale_y_kappa} are wrappers for \code{scale_x_continuous}
and \code{scale_y_continuous} which set the \code{trans} or \code{transform} parameter to
\code{kappa_trans()}.
}
\examples{
transform <- kappa_trans()

transform$transform(c(-1.96, 100))
transform$inverse(c(-1, 1))

data <- merckValues_stable
ggplot(data,aes(x=kappa))+
    geom_density()+
    scale_x_kappa("BRAID kappa")
}
