% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{drawbetaOR2}
\alias{drawbetaOR2}
\title{Samples \eqn{\beta} in the OR2 model}
\usage{
drawbetaOR2(z, x, sigma, nu, tau2, theta, invB0, invB0b0)
}
\arguments{
\item{z}{continuous latent values, vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{sigma}{\eqn{\sigma}, a scalar value.}

\item{nu}{modified latent weight, column vector of size \eqn{(n x 1)}.}

\item{tau2}{2/(p(1-p)).}

\item{theta}{(1-2p)/(p(1-p)).}

\item{invB0}{inverse of prior covariance matrix of normal distribution.}

\item{invB0b0}{prior mean pre-multiplied by invB0.}
}
\value{
Returns a list with components
\itemize{
\item{\code{beta}: }{\eqn{\beta}, a column vector of size \eqn{(k x 1)}, sampled from its
condtional posterior distribution.}
\item{\code{Btilde}: }{variance parameter for the posterior
multivariate normal distribution.}
\item{\code{btilde}: }{mean parameter for the
posterior multivariate normal distribution.}
}
}
\description{
This function samples \eqn{\beta} from its conditional
posterior distribution in the OR2 model (ordinal quantile model with exactly 3
outcomes).
}
\details{
This function samples \eqn{\beta}, a vector, from its conditional posterior distribution
which is an updated multivariate normal distribution.
}
\examples{
set.seed(101)
z <- c(21.01744, 33.54702, 33.09195, -3.677646,
 21.06553, 1.490476, 0.9618205, -6.743081, 21.02186, 0.6950479)
x <- matrix(c(
     1, -0.3010490, 0.8012506,
     1,  1.2764036, 0.4658184,
     1,  0.6595495, 1.7563655,
     1, -1.5024607, -0.8251381,
     1, -0.9733585, 0.2980610,
     1, -0.2869895, -1.0130274,
     1,  0.3101613, -1.6260663,
     1, -0.7736152, -1.4987616,
     1,  0.9961420, 1.2965952,
     1, -1.1372480, 1.7537353),
     nrow = 10, ncol = 3, byrow = TRUE)
sigma <- 1.809417
n <- dim(x)[1]
nu <- array(5 * rep(1,n), dim = c(n, 1))
tau2 <- 10.6667
theta <- 2.6667
invB0 <- matrix(c(
     1, 0, 0,
     0, 1, 0,
     0, 0, 1),
     nrow = 3, ncol = 3, byrow = TRUE)
invB0b0 <- c(0, 0, 0)

output <- drawbetaOR2(z, x, sigma, nu, tau2, theta, invB0, invB0b0)

# output$beta
#   -0.74441 1.364846 0.7159231

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
}
\seealso{
Gibbs sampling, normal distribution
, \link[GIGrvg]{rgig}, \link[pracma]{inv}
}
