% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{summary.bqrorOR2}
\alias{summary.bqrorOR2}
\title{Extractor function for summary}
\usage{
\method{summary}{bqrorOR2}(object, digits, ...)
}
\arguments{
\item{object}{bqrorOR2 object from which the summary is extracted.}

\item{digits}{controls the number of digits after the decimal}

\item{...}{extra arguments}
}
\value{
the summarized information object
}
\description{
This function extracts the summary from the bqrorOR2 object
}
\details{
This function is an extractor function for the summary
}
\examples{
set.seed(101)
data("data25j3")
y <- data25j3$y
xMat <- data25j3$x
k <- dim(xMat)[2]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
n0 <- 5
d0 <- 8
output <- quantregOR2(y = y, x = xMat, b0, B0, n0, d0, gammacp2 = 3,
burn = 10, mcmc = 40, p = 0.25, accutoff = 0.5, FALSE)
summary(output, 4)

#            Post Mean Post Std Upper Credible Lower Credible Inef Factor
#    beta_1   -4.5185   0.9837        -3.1726        -6.2000     1.5686
#    beta_2    6.1825   0.9166         7.6179         4.8619     1.5240
#    beta_3    5.2984   0.9653         6.9954         4.1619     1.4807
#    sigma     1.0879   0.2073         1.5670         0.8436     2.4228

}
