% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data25j4}
\alias{data25j4}
\title{Data containing 500 observations generated from the quantile
ordinal model with 4 outcomes and \eqn{p = 0.25} (i.e., 25th quantile)}
\usage{
data(data25j4)
}
\value{
Returns a list with components
\itemize{
\item{\code{x}: }{a matrix of covariates.}
\item{\code{y}: }{a matrix of ordinal outcomes.}
}
}
\description{
Data containing 500 observations generated from the quantile
ordinal model with 4 outcomes and \eqn{p = 0.25} (i.e., 25th quantile)
}
\details{
This data contains 500 observations generated from the quantile
ordinal model with more than 3 outcomes at the 25th quantile (i.e., \eqn{p = 0.25}).
The model specifications for generating the data are as follows: \eqn{\beta = (-4, 5, 6)}, X ~ Unif(0, 1), and
\eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.25}).

The errors are generated from the asymmetric Laplace distribution
using the normal exponential mixture formulation. The cut-points \eqn{(0, 2, 4)}
are used to categorize the continuous values into 4 ordinal outcomes.
}
\references{
Kozumi, H., and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
 Journal of Statistical Computation and Simulation, 81(11), 1565–1578. DOI: 10.1080/00949655.2010.496117

Yu, K., and Zhang, J. (2005). “A Three-Parameter Asymmetric
Laplace Distribution.” Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
}
\seealso{
\link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
}
\keyword{datasets}
