% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariate_effect.R
\name{covariateEffect_or1}
\alias{covariateEffect_or1}
\title{Covariate Effect for Bayesian Quantile Regression for Ordinal Model
with more than 3 outcomes}
\usage{
covariateEffect_or1(model, y, x, modX, p)
}
\arguments{
\item{model}{outcome of the ODR I (quantreg_or1) model.}

\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{modX}{matrix x with suitable modification to an independent variable including a column of ones with or without column names.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components:
\itemize{
\item{\code{avgDiffProb}: }{a vector with change in predicted
probabilities for each outcome category.}
}
}
\description{
This function estimates the change in probability of different ordinal
outcomes due to change in an independent variable, marginalized over
the parameters and values of other covariates
}
\details{
Function estimates the covariate effect of the change in an independent
variable. The effect is marginalized over other parameters and values of other covariates.
This function can only be used for ordinal models with more than 3 outcomes. Function uses
the output of ODR I model to compute the covariate effect.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
k <- dim(x)[2]
J <- dim(as.array(unique(y)))[1]
D0 <- 0.25*diag(J - 2)
output <- quantreg_or1(y = y,x = x, B0 = 10*diag(k), D0 = D0,
mcmc = 50, p = 0.25, tune = 1)
modX <- x
modX[,3] <- modX[,3] + 0.02
res <- covariateEffect_or1(output, y, x, modX, p = 0.25)

# avgDiffProb
#   -0.007821158 -0.001108564 -0.008400506  0.009509070

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econo-
metrics, 23: 115–156.
}
