% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRII.R
\name{drawlatent3}
\alias{drawlatent3}
\title{Samples the Latent Variable z for an Ordinal Model
with 3 outcomes}
\usage{
drawlatent3(y, x, beta, sigma, nu, theta, tau2, gammacp)
}
\arguments{
\item{y}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{beta}{column vector of coeffcients of dimension \eqn{(k x 1)}.}

\item{sigma}{scale factor, a scalar value.}

\item{nu}{modified scale factor, row vector.}

\item{theta}{(1-2p)/(p(1-p)).}

\item{tau2}{2/(p(1-p)).}

\item{gammacp}{row vector of cutpoints including -Inf and Inf.}
}
\value{
Returns a column vector of values for latent variable z.
}
\description{
This function samples the latent variable z from a truncated
normal distribution for an ordinal model with 3 outcomes.
}
\details{
Function samples the latent variable z from a truncated normal
distribution.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
beta <- c(1.7201671, 1.9562172, 0.8334668)
sigma <- 0.9684741
nu <- c(5, 5, 5, 5, 5, 5, 5, 5, 5, 5)
theta <- 2.6667
tau2 <- 10.6667
gammacp <- c(-Inf, 0, 4, Inf)
ans <- drawlatent3(y, x, beta, sigma, nu,
theta, tau2, gammacp)

# ans
#   12.79298 20.40747 1.557821
#   26.07846 17.41031 12.86016
#   3.364703 21.61075 2.666627 .. soon

}
\references{
Albert, J. and Chib, S. (1993). “Bayesian Analysis of Binary and Polychotomous
Response Data.” Journal of the American Statistical Association, 88(422): 669–679.

Casella, G., George E. I. (1992). “Explaining the Gibbs Sampler."
The American Statistician, 46(3): 167-174.

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images."
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741.
}
\seealso{
Gibbs sampling, truncated normal distribution,
\link[truncnorm]{rtruncnorm}
}
