% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposalLambda.R
\name{CalculateProposalLambda}
\alias{CalculateProposalLambda}
\title{CalculateProposalLambda}
\usage{
CalculateProposalLambda(hparam, thetaYList, CxyList, constraint, m, p,
  qVec)
}
\arguments{
\item{hparam}{hparam}

\item{thetaYList}{thetaYList}

\item{CxyList}{CxyList}

\item{constraint}{constraint}

\item{m}{the number of clusters}

\item{p}{the number of features}

\item{qVec}{the vector of the number of factors in each clusters}
}
\description{
CalculateProposalLambda
}
\examples{
set.seed(100)
n <- 10
p <- 2
q <- 1
K <- 2
X <- t(
  fabMix::simData(
    sameLambda = TRUE,
    sameSigma = TRUE,
    K.true = K,
    n = n,
    q = q,
    p = p,
    sINV_values = 1 / ((1:p))
  )$data
)
m <- 1
muBar <- c(0, 0)

hparam <- new(
  "Hparam",
  alpha1 = 0.567755037123148,
  alpha2 = 1.1870201935945,
  delta = 2,
  ggamma = 2,
  bbeta = 3.39466184520673
)
qVec <- c(1, 1)
constraint <- c(0, 0, 0)
ZOneDim <- sample(seq_len(m), n, replace = TRUE)
thetaYList <-
  new(
    "ThetaYList",
    tao = 0.366618687752634,
    psy = list(structure(
      c(
        4.18375613018654,
        0, 0, 5.46215996830771
      ),
      .Dim = c(2L, 2L)
    )),
    M = list(structure(
      c(
        3.27412045866392,
        -2.40544145363349
      ),
      .Dim = 1:2
    )),
    lambda = list(structure(
      c(
        2.51015961514781,
        -0.0741189919182549
      ),
      .Dim = 2:1
    )),
    Y = list(structure(
      c(
        -0.244239011725104,
        -0.26876172736886,
        0.193431511203083,
        0.41624466812811,
        -0.54581548068437,
        -0.0479517628308146,
        -0.633383997203325,
        0.856855296613208,
        0.792850576988512,
        0.268208848994559
      ),
      .Dim = c(1L, 10L)
    ))
  )
CxyList <-
  list(
    A = list(structure(
      c(0.567755037123148, 0, 0, 1.1870201935945),
      .Dim = c(2L, 2L)
    )),
    nVec = structure(10, .Dim = c(1L, 1L)),
    Cxxk = list(structure(
      c(
        739.129405647622,
        671.040583460732,
        671.040583460732,
        618.754338945564
      ),
      .Dim = c(2L, 2L)
    )),
    Cxyk = list(structure(
      c(-18.5170828875512, -16.5748393456787),
      .Dim = 2:1
    )),
    Cyyk = list(structure(2.4786991560888, .Dim = c(
      1L,
      1L
    ))),
    Cytytk = list(structure(
      c(
        10, 0.787438922114998, 0.787438922114998,
        2.4786991560888
      ),
      .Dim = c(2L, 2L)
    )),
    Cxtytk = list(structure(
      c(
        -57.5402230447872,
        -54.6677145995824,
        -18.5170828875512,
        -16.5748393456787
      ),
      .Dim = c(
        2L,
        2L
      )
    )),
    CxL1k = list(structure(
      c(-59.5168204264758, -54.6093504204781),
      .Dim = 2:1
    )),
    Cxmyk = list(structure(
      c(
        -21.0952527723962,
        -14.6807011202188
      ),
      .Dim = 2:1
    )),
    sumCxmyk = structure(c(
      -21.0952527723962,
      -14.6807011202188
    ), .Dim = 2:1),
    sumCyyk = structure(3.6657193496833, .Dim = c(
      1L,
      1L
    ))
  )
\donttest{
CalculateProposalLambda(hparam, thetaYList, CxyList, constraint, m, p, qVec)
}

}
