% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.r
\name{s3}
\alias{s3}
\alias{is_S3_user_generic}
\alias{make_S3_methods_known}
\title{Internal S3 infrastructure helpers}
\usage{
is_S3_user_generic(function_name, envir = parent.frame())

make_S3_methods_known(module)
}
\arguments{
\item{function_name}{function name as character string.}

\item{envir}{the environment this function is invoked from.}

\item{module}{the module object for which to register S3 methods}
}
\value{
\code{is_S3_user_generic} returns \code{TRUE} if the specified
function is a user-defined S3 generic, \code{FALSE} otherwise.
}
\description{
The following are internal S3 infrastructure helper functions.
}
\details{
\code{is_S3_user_generic} checks whether a function given by name is a
user-defined generic. A user-defined generic is any function which, at some
point, calls \code{UseMethod}.

\code{make_S3_methods_known} finds and registers S3 methods inside a module.
}
\keyword{internal}
