% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_statistics.R
\name{signal_statistics}
\alias{signal_statistics}
\alias{absolute_gini_coefficient}
\alias{sample_absolute_gini_coefficient}
\alias{hoyer_sparsity}
\alias{oracle_snr}
\alias{oracle_snr_db}
\alias{m2m4_snr_estimator}
\alias{m2m4_snr_estimator_db}
\title{Signal Statistics Functions}
\usage{
absolute_gini_coefficient(x)

sample_absolute_gini_coefficient(x)

hoyer_sparsity(x)

oracle_snr(signal, noisy_signal)

oracle_snr_db(signal, noisy_signal)

m2m4_snr_estimator(noisy_signal, signal_kurtosis = 1, noise_kurtosis = 3)

m2m4_snr_estimator_db(noisy_signal, signal_kurtosis = 1, noise_kurtosis = 3)
}
\arguments{
\item{x}{A numeric vector.}

\item{signal}{A numeric vector.}

\item{noisy_signal}{A numeric vector.}

\item{signal_kurtosis}{A single numeric value.}

\item{noise_kurtosis}{A single numeric value.}
}
\value{
A numeric value or vector with the computed statistic.
}
\description{
Functions to compute various signal statistics.
}
\examples{
# Absolute Gini Coefficient
absolute_gini_coefficient(c(1, 2, 3, 4, 5))
# Sample Absolute Gini Coefficient
sample_absolute_gini_coefficient(c(1, 2, 3, 4, 5))
# Hoyer Sparsity
hoyer_sparsity(c(1, 0, 0, 2, 3))

signal <- c(1, 2, 3)
noisy_signal <- c(1.1, 2.1, 3.1)
# Oracle SNR
oracle_snr(signal, noisy_signal)
# Oracle SNR in dB
oracle_snr_db(signal, noisy_signal)
# M2M4 SNR Estimator
m2m4_snr_estimator(noisy_signal, 3, 2)
# M2M4 SNR Estimator in dB
m2m4_snr_estimator_db(noisy_signal, 3, 2)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/signal_statistics.html}{Boost Documentation} for more details on the mathematical background.
}
