% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_distribution.R
\name{weibull_distribution}
\alias{weibull_distribution}
\alias{weibull_pdf}
\alias{weibull_lpdf}
\alias{weibull_cdf}
\alias{weibull_lcdf}
\alias{weibull_quantile}
\title{Weibull Distribution Functions}
\usage{
weibull_pdf(x, shape = 1, scale = 1)

weibull_lpdf(x, shape = 1, scale = 1)

weibull_cdf(x, shape = 1, scale = 1)

weibull_lcdf(x, shape = 1, scale = 1)

weibull_quantile(p, shape = 1, scale = 1)
}
\arguments{
\item{x}{quantile}

\item{shape}{shape parameter (default is 1)}

\item{scale}{scale parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Weibull distribution.
}
\examples{
# Weibull distribution with shape = 1, scale = 1
weibull_pdf(1)
weibull_lpdf(1)
weibull_cdf(1)
weibull_lcdf(1)
weibull_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/dist_ref/dists/weibull_dist.html}{Boost Documentation} for more details on the mathematical background.
}
