% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobi_theta_functions.R
\name{jacobi_theta_functions}
\alias{jacobi_theta_functions}
\alias{jacobi_theta1}
\alias{jacobi_theta1tau}
\alias{jacobi_theta2}
\alias{jacobi_theta2tau}
\alias{jacobi_theta3}
\alias{jacobi_theta3tau}
\alias{jacobi_theta3m1}
\alias{jacobi_theta3m1tau}
\alias{jacobi_theta4}
\alias{jacobi_theta4tau}
\alias{jacobi_theta4m1}
\alias{jacobi_theta4m1tau}
\title{Jacobi Theta Functions}
\usage{
jacobi_theta1(x, q)

jacobi_theta1tau(x, tau)

jacobi_theta2(x, q)

jacobi_theta2tau(x, tau)

jacobi_theta3(x, q)

jacobi_theta3tau(x, tau)

jacobi_theta3m1(x, q)

jacobi_theta3m1tau(x, tau)

jacobi_theta4(x, q)

jacobi_theta4tau(x, tau)

jacobi_theta4m1(x, q)

jacobi_theta4m1tau(x, tau)
}
\arguments{
\item{x}{Input value}

\item{q}{The nome parameter of the Jacobi theta function (0 < q < 1)}

\item{tau}{The nome parameter of the Jacobi theta function (tau = u + iv, where u and v are real numbers)}
}
\value{
A single numeric value with the computed Jacobi theta function.
}
\description{
Functions to compute the Jacobi theta functions \eqn{(\theta_1, \theta_2, \theta_3, \theta_4)} parameterised by either \eqn{(q)} or \eqn{(\tau)}.
}
\examples{
# Jacobi Theta Functions
x <- 0.5
q <- 0.9
tau <- 1.5
jacobi_theta1(x, q)
jacobi_theta1tau(x, tau)
jacobi_theta2(x, q)
jacobi_theta2tau(x, tau)
jacobi_theta3(x, q)
jacobi_theta3tau(x, tau)
jacobi_theta3m1(x, q)
jacobi_theta3m1tau(x, tau)
jacobi_theta4(x, q)
jacobi_theta4tau(x, tau)
jacobi_theta4m1(x, q)
jacobi_theta4m1tau(x, tau)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/jacobi_theta.html}{Boost Documentation} for more details on the mathematical background.
}
