% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_hyperbolic_functions.R
\name{inverse_hyperbolic_functions}
\alias{inverse_hyperbolic_functions}
\alias{acosh_boost}
\alias{asinh_boost}
\alias{atanh_boost}
\title{Inverse Hyperbolic Functions}
\usage{
acosh_boost(x)

asinh_boost(x)

atanh_boost(x)
}
\arguments{
\item{x}{Input numeric value}
}
\value{
A single numeric value with the computed inverse hyperbolic function.
}
\description{
Functions to compute the inverse hyperbolic functions: acosh, asinh, and atanh.
}
\examples{
# Inverse Hyperbolic Cosine
acosh_boost(2)
# Inverse Hyperbolic Sine
asinh_boost(1)
# Inverse Hyperbolic Tangent
atanh_boost(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/inv_hyper.html}{Boost Documentation} for more details on the mathematical background.
}
