% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_identify_parents.R
\name{bold_identify_parents}
\alias{bold_identify_parents}
\title{Add taxonomic parent names to a data.frame}
\usage{
bold_identify_parents(x, wide = FALSE, taxid = NULL, taxon = NULL,
  tax_rank = NULL, tax_division = NULL, parentid = NULL,
  parentname = NULL, taxonrep = NULL, specimenrecords = NULL)
}
\arguments{
\item{x}{(data.frame/list) list of data.frames - the output from a call to
\code{\link{bold_identify}}. or a single data.frame from the output from
same. required.}

\item{wide}{(logical) output in long or wide format. See Details.
Default: \code{FALSE}}

\item{taxid}{(character) A taxid name. Optional. See `Filtering` below.}

\item{taxon}{(character) A taxon name. Optional. See `Filtering` below.}

\item{tax_rank}{(character) A tax_rank name. Optional. See `Filtering` 
below.}

\item{tax_division}{(character) A tax_division name. Optional. See 
`Filtering` below.}

\item{parentid}{(character) A parentid name. Optional. See `Filtering` 
below.}

\item{parentname}{(character) A parentname name. Optional. See `Filtering` 
below.}

\item{taxonrep}{(character) A taxonrep name. Optional. See `Filtering` 
below.}

\item{specimenrecords}{(character) A specimenrecords name. Optional. 
See `Filtering` below.}
}
\value{
a list of the same length as the input
}
\description{
Add taxonomic parent names to a data.frame
}
\details{
This function gets unique set of taxonomic names from the input
data.frame, then queries \code{\link{bold_tax_name}} to get the
taxonomic ID, passing it to \code{\link{bold_tax_id}} to get the parent
names, then attaches those to the input data.

Records in the input data that do not have matches for parent names
simply get NA values in the added columns.
}
\section{Filtering}{

The parameters `taxid`, `taxon`, `tax_rank`, `tax_division`, 
`parentid`, `parentname`,`taxonrep`, and `specimenrecords` are not used 
in the search sent to BOLD, but are used in filtering the data down 
to a subset that is closer to the target you want. For all these 
parameters, you can use regex strings since we use [grep()] internally 
to match. Filtering narrows down to the set that matches your query, 
and removes the rest. The data.frame that we filter on with these 
parameters internally is the result of a call to the [bold_tax_name()]
function.
}

\section{wide vs long format}{

When \code{wide = FALSE} you get many rows for each record. Essentially,
we \code{cbind} the taxonomic classification onto the one row from the
result of \code{\link{bold_identify}}, giving as many rows as there are
taxa in the taxonomic classification.

When \code{wide = TRUE} you get one row for each record - thus the
dimensions of the input data stay the same. For this option, we take just
the rows for taxonomic ID and name for each taxon in the taxonomic
classification, and name the columns by the taxon rank, so you get
\code{phylum} and \code{phylum_id}, and so on.
}

\examples{
\dontrun{
df <- bold_identify(sequences = sequences$seq2)

# long format
out <- bold_identify_parents(df)
str(out)
head(out[[1]])

# wide format
out <- bold_identify_parents(df, wide = TRUE)
str(out)
head(out[[1]])
}
}
