% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obd.select.R
\name{obd.select}
\alias{obd.select}
\title{Optimal biological dose selection}
\usage{
obd.select(
  probt, probe, method,
  phi, phi1, phi2, delta, delta1,
  tterm, eterm, stopT, stopE,
  w1, w2,
  plow.ast, pupp.ast, qlow.ast, qupp.ast,
  psi00, psi11)
}
\arguments{
\item{probt}{Estimated toxicity probability.}

\item{probe}{Estimated efficacy probability.}

\item{method}{Method used for OBD selection.}

\item{phi}{Target toxicity probability.}

\item{phi1}{Lower bound of toxicity probability.}

\item{phi2}{Upper bound of toxicity probability.}

\item{delta}{Target efficacy probability.}

\item{delta1}{Lower bound of efficacy probability.}

\item{tterm}{Probability of meeting toxicity stopping criteria.}

\item{eterm}{Probability of meeting efficacy stopping criteria.}

\item{stopT}{Toxicity stopping criteria.}

\item{stopE}{Efficacy stopping criteria.}

\item{w1}{Weight for toxicity-efficacy trade-off.}

\item{w2}{Weight for penalty imposed on toxic doses.}

\item{plow.ast}{Lower threshold of toxicity linear truncated function.}

\item{pupp.ast}{Upper threshold of toxicity linear truncated function.}

\item{qlow.ast}{Lower threshold of efficacy linear truncated function.}

\item{qupp.ast}{Upper threshold of efficacy linear truncated function.}

\item{psi00}{Score for toxicity=no and efficacy=no.}

\item{psi11}{Score for toxicity=yes and efficacy=yes.}
}
\value{
The \code{obd.select} returns an optimal biological dose.
}
\description{
Optimal biological dose (OBD) is selected by a method specified.
}
