% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_prop_1d_linear.R
\name{admix_prop_1d_linear}
\alias{admix_prop_1d_linear}
\title{Construct admixture proportion matrix for 1D geography}
\usage{
admix_prop_1d_linear(
  n_ind,
  k_subpops,
  sigma = NA,
  coord_ind_first = 0.5,
  coord_ind_last = k_subpops + 0.5,
  bias_coeff = NA,
  coanc_subpops = NULL,
  fst = NA
)
}
\arguments{
\item{n_ind}{Number of individuals.}

\item{k_subpops}{Number of intermediate subpopulations.}

\item{sigma}{Spread of intermediate subpopulations (standard deviation of normal densities).
The edge cases \code{sigma = 0} and \code{sigma = Inf} are handled appropriately!}

\item{coord_ind_first}{Location of first individual (default \code{0.5}).}

\item{coord_ind_last}{Location of last individual (default \code{k_subpops + 0.5}).

OPTIONS FOR BIAS COEFFICIENT VERSION}

\item{bias_coeff}{If \code{sigma} is \code{NA}, this bias coefficient is required.}

\item{coanc_subpops}{If \code{sigma} is \code{NA}, this intermediate subpops coancestry is required.
It can be provided as a \code{k_subpops}-by-\code{k_subpops} matrix, a length-\code{k_subpops} population inbreeding vector (for independent subpopulations, where between-subpop coancestries are zero) or scalar (if population inbreeding values are all equal and coancestries are zero).
This \code{coanc_subpops} can be in the wrong scale (it cancels out in calculations), which is returned corrected, to result in the desired \code{fst} (next).}

\item{fst}{If \code{sigma} is \code{NA}, this FST of the admixed individuals is required.}
}
\value{
If \code{sigma} was provided, the \code{n_ind}-by-\code{k_subpops} admixture proportion matrix (\code{admix_proportions}).
If \code{sigma} is missing, a named list is returned containing \code{admix_proportions}, the rescaled \code{coanc_subpops}, and the \code{sigma} (which together give the desired \code{bias_coeff} and \code{fst}).
}
\description{
Assumes \code{k_subpops} intermediate subpopulations placed along a line at locations \code{1 : k_subpops} spread by random walks, then \code{n_ind} individuals equally spaced in [\code{coord_ind_first},\code{coord_ind_last}] draw their admixture proportions relative to the Normal density that models the random walks of each of these intermediate subpopulations.
The spread of the random walks (the standard deviation of the Normal densities) is \code{sigma}.
If \code{sigma} is missing, it can be set indirectly by providing three variables: (1) the desired bias coefficient \code{bias_coeff}, (2) the coancestry matrix of the intermediate subpopulations \code{coanc_subpops} (up to a scalar factor), and (3) the final \code{fst} of the admixed individuals (see details below).
}
\details{
If \code{sigma} is \code{NA}, its value is determined from the desired \code{bias_coeff}, \code{coanc_subpops} up to a scalar factor, and \code{fst}.
Uniform weights for the final generalized FST are assumed.
The scale of \code{coanc_subpops} is irrelevant because it cancels out in \code{bias_coeff}; after \code{sigma} is found, \code{coanc_subpops} is rescaled to give the desired final FST.
However, the function stops if any rescaled \code{coanc_subpops} values are greater than 1, which are not allowed since they are IBD probabilities.
}
\examples{
# admixture matrix for 1000 individuals drawing alleles from 10 subpops
# simple version: spread of 2 standard deviations along the 1D geography
# (just set sigma)
admix_proportions <- admix_prop_1d_linear(n_ind = 1000, k_subpops = 10, sigma = 2)

# as sigma approaches zero, admix_proportions approaches the independent subpopulations matrix
admix_prop_1d_linear(n_ind = 10, k_subpops = 2, sigma = 0)

# advanced version: a similar model but with a bias coefficient of exactly 1/2
# (must provide bias_coeff, coanc_subpops, and fst in lieu of sigma)
k_subpops <- 10
# FST vector for intermediate independent subpops, up to a factor (will be rescaled below)
coanc_subpops <- 1 : k_subpops
obj <- admix_prop_1d_linear(
    n_ind = 1000,
    k_subpops = k_subpops,
    bias_coeff = 0.5,
    coanc_subpops = coanc_subpops,
    fst = 0.1 # desired final FST of admixed individuals
)

# in this case return value is a named list with three items:
# admixture proportions
admix_proportions <- obj$admix_proportions

# rescaled coancestry data (matrix or vector) for intermediate subpops
coanc_subpops <- obj$coanc_subpops

# and the sigma that gives the desired bias_coeff and final FST
sigma <- obj$sigma

}
