% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewi.R
\name{ewi}
\alias{ewi}
\title{Edge-weigthed influence}
\usage{
ewi(bnfit, node)
}
\arguments{
\item{bnfit}{object of class \code{bn.fit}.}

\item{node}{a node of \code{bnfit}}
}
\value{
A dataframe with the following columns: \code{Nodes} - the vertices of the BN; \code{Influence} - the edge-weigthed influence of the corresponding node.
}
\description{
Computation of the edge-weigthed influence in a Bayesian network
}
\details{
The edge-weigthed influence of a node \eqn{X_j} on an output node \eqn{X_i} in a Bayesian network is \deqn{EWI(X_j,X_i)= \sum_{s\in S_{ji}}\left(\prod_{(k,l)\in s}\delta_{kl}\right)^{|s|},} where \eqn{S_{ji}} is the set of active trails between \eqn{X_j} and \eqn{X_i}, \eqn{\delta_{kl}} is the strength of an edge between \eqn{X_k} and \eqn{X_l}, and \eqn{|s|} is the length of the trail \eqn{s}.
}
\examples{
ewi(travel, "T")

}
\references{
Leonelli, M., Smith, J. Q., & Wright, S. K. (2024). The diameter of a stochastic matrix: A new measure for sensitivity analysis in Bayesian networks. arXiv preprint arXiv:2407.04667.
}
\seealso{
\code{\link{mutual_info}}, \code{\link{dwi}}, \code{\link{edge_strength}}
}
