#' polymorphic Bayesian Network
#'
#' Reliability analysis of high-voltage drive motor systems in terms of the polymorphic Bayesian network.
#'
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network to depict the high-voltage drive motor system’s miscellaneous fault states. Probabilities were given within the referenced paper. The vertices are:
#' \describe{
#'   \item{PresenceAbrasiveParticles}{(Normal, Degradation, Failed);}
#'   \item{ExcessiveSpeed}{(Normal, Degradation, Failed);}
#'   \item{PoorLubrification}{(Normal, Degradation, Failed);}
#'   \item{InappropriateClearance}{(Normal, Degradation, Failed);}
#'   \item{HighTemperatureGluing}{(Normal, Degradation, Failed);}
#'   \item{ScratchVibration}{(Normal, Degradation, Failed);}
#'   \item{Indentation}{(Normal, Degradation, Failed);}
#'   \item{ImproperLubrification}{(Normal, Degradation, Failed);}
#'   \item{ImproperAssembly}{(Normal, Degradation, Failed);}
#'   \item{Moisture}{(Normal, Degradation, Failed);}
#'   \item{ExcessiveInterShaftCurrent}{(Normal, Degradation, Failed);}
#'   \item{ChemicalCorrosion}{(Normal, Degradation, Failed);}
#'   \item{HighFrequencyPulseVoltage}{(Normal, Degradation, Failed);}
#'   \item{LocalizedHighTemperatures}{(Normal, Degradation, Failed);}
#'   \item{PoorCooling}{(Normal, Degradation, Failed);}
#'   \item{SeverePartialDischarges}{(Normal, Degradation, Failed);}
#'   \item{SurfaceCorrosion}{(Normal, Degradation, Failed);}
#'   \item{PlasticDeformation}{(Normal, Degradation, Failed);}
#'   \item{CorrosionFailure}{(Normal, Degradation, Failed);}
#'   \item{InsulationDeterioration}{(Normal, Degradation, Failed);}
#'   \item{WearFault}{(Normal, Degradation, Failed);}
#'   \item{SystemDegradation}{(Normal, Degradation, Failed);}
#' }
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @keywords ReverseTree
#' @importClassesFrom bnlearn bn.fit
#' @references Zheng, W., Jiang, H., Li, S., & Ma, Q. (2023). Reliability Analysis of High-Voltage Drive Motor Systems in Terms of the Polymorphic Bayesian Network. Mathematics, 11(10), 2378.
"polymorphic"
