% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wolfe.R
\name{wolfe.linesearch}
\alias{wolfe.linesearch}
\title{Wolfe Line Search}
\usage{
wolfe.linesearch(f, x0, s0, ..., a1 = 0.5, amax = 1.1, c1 = 1e-04,
  c2 = 0.9, maxiter = 5L, f.adjust = identity)
}
\arguments{
\item{f}{a function to minimize. It must accept as first argument a numeric vector
representing the optimization point and return a numeric value, with 
gradient attribute setted}

\item{x0}{initial search point}

\item{s0}{direction of the search from x0}

\item{...}{additional parameters passed to f()}

\item{a1}{first step coefficient guess}

\item{amax}{max coefficient value}

\item{c1}{lower bound}

\item{c2}{upper bound}

\item{maxiter}{maximum number of iteration for this linesearch}

\item{f.adjust}{an adjustment method to adjust lvalue and gradient of f}
}
\value{
the optimal point
}
\description{
Implements Wolfe Line Search algorithm.
The code is inspired from Matlab code of Do and Artiere, but not tested.
The function is not used yet, but might be used later to speed up bmrm/nrbm 
convergence.
}
\examples{
fun <- function(w) {
  gradient(w) <- w
  lvalue(w) <- 0.5*sum(w*w)
  w
}
wolfe.linesearch(fun,fun(c(5,5)),c(-1,-1))
wolfe.linesearch(fun,fun(c(5,5)),c(1,1))
}
\references{
Do and Artieres
  Regularized Bundle Methods for Convex and Non-Convex Risks
  JMLR 2012
}
\seealso{
\code{\link{nrbm}}
}
\author{
Julien Prados
}
