% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_misc.R
\name{hclust.fca}
\alias{hclust.fca}
\title{Find first common ancestor of 2 nodes in an hclust object}
\usage{
hclust.fca(hc, a, b)
}
\arguments{
\item{hc}{an hclust object}

\item{a}{an integer vector with the first leaf node}

\item{b}{an integer vector with the second leaf node (same length as a)}
}
\value{
an integer vector of the same length as a and b identifing the first common ancestors of a and b
}
\description{
Find first common ancestor of 2 nodes in an hclust object
}
\examples{
  hc <- hclust(dist(USArrests), "complete")
  plot(hc)
  A <- outer(seq_along(hc$order),seq_along(hc$order),hclust.fca,hc=hc)
  H <- array(hc$height[A],dim(A))
  image(H[hc$order,hc$order])
  image(A[hc$order,hc$order])
}
\author{
Julien Prados
}
