% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_plot.R
\name{mlm_path_plot}
\alias{mlm_path_plot}
\title{Plot \code{bmlm}'s mediation model as a path diagram}
\usage{
mlm_path_plot(mod = NULL, xlab = "X", ylab = "Y", mlab = "M",
  border.width = 2, edge.label.cex = 1, edge.color = "black",
  fade = FALSE, level = 0.99, text = FALSE, template = FALSE,
  id = NULL, ...)
}
\arguments{
\item{mod}{A Stanfit model estimated with \code{mlm()}.}

\item{xlab}{Label for X}

\item{ylab}{Label for Y}

\item{mlab}{Label for M}

\item{border.width}{Size of node borders (defaults to 2).}

\item{edge.label.cex}{Text size.}

\item{edge.color}{Color of the path arrows. (Set NULL to color negative paths
red, and positive paths green.)}

\item{fade}{Should edges fade to white? (Defaults to FALSE.)}

\item{level}{"Confidence" level for credible intervals. (Defaults to .99.)}

\item{text}{Should additional parameter values be displayed?
(Defaults to FALSE.)}

\item{template}{Should an empty template diagram be plotted?
(Defaults to FALSE.)}

\item{id}{Plot an individual-level path diagram by specifying ID number.}

\item{...}{Other arguments passed on to \code{qgraph::qgraph()}.}
}
\value{
A qgraph object.
}
\description{
Plots a path diagram for an estimated multilevel mediation model.
}
\details{
Plots a path diagram of the mediation model,
with estimated parameter values and credible intervals. Can also
be used to draw a template diagram of the mediation model by setting
\code{template = TRUE}.
}
\examples{
# Draw a template path diagram of the mediation model
mlm_path_plot(template = TRUE)

}
\author{
Matti Vuorre \email{mv2521@columbia.edu}
}

