% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_tables.R
\name{tidy_table_as_zoo}
\alias{tidy_table_as_zoo}
\title{Convert a single series or n series tables into a zoo object}
\usage{
tidy_table_as_zoo(table, index_function = .zoo_index_function)
}
\arguments{
\item{table}{a table of results}

\item{index_function}{optional closure. The closure parameter is the \code{table}
and it should return a vector of values compatible with a \code{zoo} index. The
default function will return a vector of \code{\link[zoo:yearmon]{zoo::yearmon}} for monthly series and
\code{\link[zoo:yearqtr]{zoo::yearqtr}} for quarterly or annual series.}
}
\value{
a \code{zoo}object
}
\description{
Convert a single series or n series tables into a zoo object
}
\details{
A utility function to easily convert retrieved BLS series into
\code{zoo} or \code{xts} objects.
}
\examples{
\dontrun{
series <- get_series('LNS14000001')
table <- data_as_tidy_table(series$data)
zoo_obj <- tidy_table_as_zoo(table)
}
}
\seealso{
Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{tidy_periods}()}
}
\concept{blsR-utils}
