% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-fit-stats.R
\name{blr_model_fit_stats}
\alias{blr_model_fit_stats}
\title{Model fit statistics}
\usage{
blr_model_fit_stats(model, ...)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{...}{Other inputs.}
}
\description{
Model fit statistics.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_model_fit_stats(model)

}
\references{
Menard, S. (2000). Coefficients of determination for multiple logistic regression analysis. 
The American Statistician, 54(1), 17-24.

Windmeijer,  F.  A.  G.  (1995).  Goodness-of-fit  measures  in  binary  choice  models. Econometric 
Reviews, 14, 101-116.

Hosmer,  D.W.,  Jr.,  &  Lemeshow,  S.  (2000), Applied  logistic  regression(2nd  ed.).  
New  York:  John Wiley & Sons. 

J. Scott Long & Jeremy Freese, 2000. "FITSTAT: Stata module to compute fit statistics for 
single equation regression models," Statistical Software Components S407201, Boston College 
Department of Economics, revised 22 Feb 2001. 

Freese, Jeremy and J. Scott Long.  Regression Models for Categorical Dependent Variables 
Using Stata. College Station: Stata Press, 2006.

Long, J. Scott. Regression Models for Categorical and Limited Dependent Variables.  
Thousand Oaks: Sage Publications, 1997.
}
\seealso{
Other model fit statistics: 
\code{\link{blr_multi_model_fit_stats}()},
\code{\link{blr_pairs}()},
\code{\link{blr_rsq_adj_count}()},
\code{\link{blr_rsq_cox_snell}()},
\code{\link{blr_rsq_effron}()},
\code{\link{blr_rsq_mcfadden_adj}()},
\code{\link{blr_rsq_mckelvey_zavoina}()},
\code{\link{blr_rsq_nagelkerke}()},
\code{\link{blr_test_lr}()}
}
\concept{model fit statistics}
