% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-lorenz-curve.R
\name{blr_gini_index}
\alias{blr_gini_index}
\title{Gini index}
\usage{
blr_gini_index(model, data = NULL)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{data}{A \code{tibble} or \code{data.frame}.}
}
\value{
Gini index.
}
\description{
Gini index is a measure of inequality and was developed to measure income
  inequality in labour market. In the predictive model, Gini Index is used
  for measuring discriminatory power.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_gini_index(model)

}
\references{
Siddiqi  N  (2006):  Credit  Risk  Scorecards:  developing  and  implementing  intelligent
credit  scoring. New Jersey, Wiley.

Müller M, Rönz B (2000): Credit Scoring using Semiparametric Methods. In: Franke J, Härdle W, Stahl G (Eds.):
Measuring Risk in Complex Stochastic Systems. New York, Springer-Verlag.

\url{https://doi.org/10.2753/REE1540-496X470605}
}
\seealso{
Other model validation techniques: 
\code{\link{blr_confusion_matrix}()},
\code{\link{blr_decile_capture_rate}()},
\code{\link{blr_decile_lift_chart}()},
\code{\link{blr_gains_table}()},
\code{\link{blr_ks_chart}()},
\code{\link{blr_lorenz_curve}()},
\code{\link{blr_roc_curve}()},
\code{\link{blr_test_hosmer_lemeshow}()}
}
\concept{model validation techniques}
