% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-stepwise-backward-regression.R
\name{blr_step_p_backward}
\alias{blr_step_p_backward}
\alias{blr_step_p_backward.default}
\alias{plot.blr_step_p_backward}
\title{Stepwise backward regression}
\usage{
blr_step_p_backward(model, ...)

\method{blr_step_p_backward}{default}(model, prem = 0.3, details = FALSE,
  ...)

\method{plot}{blr_step_p_backward}(x, model = NA, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other inputs.}

\item{prem}{p value; variables with p more than \code{prem} will be removed
from the model.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{blr_step_p_backward}.}
}
\value{
\code{blr_step_p_backward} returns an object of class \code{"blr_step_p_backward"}.
An object of class \code{"blr_step_p_backward"} is a list containing the
following components:

\item{model}{model with the least AIC; an object of class \code{glm}}
\item{steps}{total number of steps}
\item{removed}{variables removed from the model}
\item{aic}{akaike information criteria}
\item{bic}{bayesian information criteria}
\item{dev}{deviance}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by
removing predictors based on p values, in a stepwise manner until there is
no variable left to remove any more.
}
\examples{
\dontrun{
# stepwise backward regression
model <- glm(honcomp ~ female + read + science + math + prog + socst,
  data = hsb2, family = binomial(link = 'logit'))
blr_step_p_backward(model)

# stepwise backward regression plot
model <- glm(honcomp ~ female + read + science + math + prog + socst,
  data = hsb2, family = binomial(link = 'logit'))
k <- blr_step_p_backward(model)
plot(k)

# final model
k$model

}

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
\seealso{
Other variable selection procedures: \code{\link{blr_step_aic_backward}},
  \code{\link{blr_step_aic_both}},
  \code{\link{blr_step_aic_forward}},
  \code{\link{blr_step_p_forward}}
}
