% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-plots-data.R
\name{blr_prep_lorenz_data}
\alias{blr_prep_lorenz_data}
\title{Lorenz curve data}
\usage{
blr_prep_lorenz_data(model, data = NULL, test_data = FALSE)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{data}{A \code{tibble} or \code{data.frame}.}

\item{test_data}{Logical; \code{TRUE} if data is test data and \code{FALSE} if training data.}
}
\description{
Data for generating Lorenz curve.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
             family = binomial(link = 'logit'))
data <- model$data
blr_prep_lorenz_data(model, data, FALSE)

}
