% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-lorenz-curve.R
\name{blr_lorenz_curve}
\alias{blr_lorenz_curve}
\title{Lorenz curve}
\usage{
blr_lorenz_curve(model, data = NULL, title = "Lorenz Curve",
  xaxis_title = "Cumulative Events \%",
  yaxis_title = "Cumulative Non Events \%", diag_line_col = "red",
  lorenz_curve_col = "blue")
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{data}{A \code{tibble} or \code{data.frame}.}

\item{title}{Plot title.}

\item{xaxis_title}{X axis title.}

\item{yaxis_title}{Y axis title.}

\item{diag_line_col}{Diagonal line color.}

\item{lorenz_curve_col}{Color of the lorenz curve.}
}
\description{
Lorenz curve is a visual representation of inequality. It is
  used to measure the discriminatory power of the predictive model.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_lorenz_curve(model)

}
\seealso{
Other model validation techniques: \code{\link{blr_confusion_matrix}},
  \code{\link{blr_decile_capture_rate}},
  \code{\link{blr_decile_lift_chart}},
  \code{\link{blr_gains_table}},
  \code{\link{blr_gini_index}}, \code{\link{blr_ks_chart}},
  \code{\link{blr_roc_curve}},
  \code{\link{blr_test_hosmer_lemeshow}}
}
