% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppMOLS.R
\name{MOLS}
\alias{MOLS}
\title{Prime power MOLS from finite fields}
\usage{
MOLS(p, q, r)
}
\arguments{
\item{p}{is a prime (see description)}

\item{q}{is an integer power (see description)}

\item{r}{is the total number of replicates < p**q}
}
\value{
dataframe of factor levels for rows, columns and treatmnent sets
}
\description{
Finds MOLS for r squares of dimension p**q where r < p**q
and p is prime and either q is 1 for any p
or q < 13 for p = 2, or q < 8 for p = 3, or q < 6 for p = 5,
or q < 5 for p = 7, or q < 4 for p = 11, 13, 17 or 19  or q < 3 for
any other prime <100.
}
\details{
Finds MOLS by cyclic permuation of the elements of a prime number or the elements
of a prime-power finite field based on a suitable choice of   
primitive polynomial. Primitive polynomials for the sizes of 
finite fields outlined in the description are extracted from the
Supplement to Hansen and Mullen (1992)
}
\examples{

MOLS(2,3,7)
MOLS(3,2,4)
\donttest{MOLS(3,3,4)}
 \donttest{MOLS(23,2,2)}
 
}
\references{
HANSEN, T. & MULLEN, G. L. (1992) PRIMITIVE PolynomF::polynomialS OVER FINITE FIELDS
Mathematics of Computation, 59, 639-643 and Supplement.
}
