% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{compute_beta_sample}
\alias{compute_beta_sample}
\title{compute_beta_sample}
\usage{
compute_beta_sample(posterior_sample, param, Q, verbose = FALSE)
}
\arguments{
\item{posterior_sample}{a list provided by the function \code{Bliss_Gibbs_Sampler}.}

\item{param}{a list containing:
\describe{
\item{K}{a vector of integers, corresponding to the numbers of intervals for
      each covariate.}
\item{grids}{a numerical vector, the observation time points.}
\item{basis}{a vector of characters (optional) among : "uniform" (default),
      "epanechnikov", "gauss" and "triangular" which correspond to
      different basis functions to expand the coefficient function and the
      functional covariates.}
}}

\item{Q}{numeric}

\item{verbose}{write stuff if TRUE (optional).}
}
\value{
return a matrix containing the coefficient function posterior sample.
}
\description{
Compute the posterior coefficient function from the posterior
             sample.
}
\examples{
library(RColorBrewer)
data(data1)
data(param1)
param1$grids<-data1$grids
# result of res_bliss1<-fit_Bliss(data=data1,param=param1)
data(res_bliss1)
beta_sample <- compute_beta_sample(posterior_sample=res_bliss1$posterior_sample,
                                   param=param1,Q=1)
indexes <- sample(nrow(beta_sample[[1]]),1e2,replace=FALSE)
cols <- colorRampPalette(brewer.pal(9,"YlOrRd"))(1e2)
matplot(param1$grids[[1]],t(beta_sample[[1]][indexes,]),type="l",lty=1,col=cols,
xlab="grid",ylab="")
}
