% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_rsc_example_files.R
\name{prepare_rsc_example_files}
\alias{prepare_rsc_example_files}
\title{Prepare example files for RStudio Connect emailing with R Markdown}
\usage{
prepare_rsc_example_files(path = NULL)
}
\arguments{
\item{path}{The location to which the files (in a subdirectory named
\code{"connect_examples"}) will be written. The path needs to exist but the
aforementioned subdirectory is not required to be present.}
}
\description{
A set of example files relevant to emailing with R Markdown in RStudio
Connect can be spawned in a specified location. There is a set of three files
that work together to provide a full report, an emailable version of that
report, and a file attachment; these files are:
}
\details{
\itemize{
\item \code{"connect-example-main.Rmd"}: The main R Markdown document. Contains
a report template culminating in a final R code chunk that has calls to
\code{\link[=render_connect_email]{render_connect_email()}} and \code{\link[=attach_connect_email]{attach_connect_email()}}.
\item \code{"connect-example-email.Rmd"}: An R Markdown document that contains
the email message. It is associated with the main R Markdown document by
incorporating some of its content (i.e., by reusing chunk names and extending
assigned values). It uses the \code{blastula::blastula_email} output type in the
YAML front matter.
\item \code{"austin_home_sales.csv"}: A CSV file that will be included as an
attachment by way of the \code{attachments} argument in the
\code{\link[=attach_connect_email]{attach_connect_email()}} function call within the main R Markdown document.
}

The main report and associated email can be published by opening
\code{"connect-example-main.Rmd"} and pressing the Publish button at the top-right
of the Editor pane (please ensure beforehand that you are set up work with
RStudio Connect). If asked \code{"What do you want to publish?"}, choose the first
option where only the \code{"connect-example-main"} document is published. All
three files should be checked in the final dialog box, press the \code{Publish}
button to publish to RStudio Connect.

There is also the single \code{"connect-example-text-only.Rmd"} file that, when
published, serves as a mechanism to send a text-only email. The content of
the email is specified directly in the single \code{\link[=attach_connect_email]{attach_connect_email()}}
function call and all other text in the R Markdown file is disregarded.
}
