% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtc_sig_parallel.R
\name{wtc_sig_parallel}
\alias{wtc_sig_parallel}
\title{Parallelized Monte Carlo simulation using \code{doParallel} package.}
\usage{
wtc_sig_parallel(nrands = 300, lag1, dt, ntimesteps, pad = TRUE,
  dj = 1/12, s0, J1, max.scale = NULL, mother = "morlet",
  sig.level = 0.95, quiet = TRUE)
}
\arguments{
\item{nrands}{number of Monte Carlo randomizations. Default is 300.}

\item{lag1}{vector containing the AR(1) coefficient of each time series.}

\item{dt}{length of a time step.}

\item{ntimesteps}{number of time steps in time series.}

\item{pad}{pad the values will with zeros to increase the speed of the
transform. Default is \code{TRUE}.}

\item{dj}{spacing between successive scales. Default is 1/12.}

\item{s0}{smallest scale of the wavelet. Default is \code{2*dt}}

\item{J1}{number of scales - 1.}

\item{max.scale}{maximum scale}

\item{mother}{type of mother wavelet function to use. Can be set to
\code{morlet}, \code{dog}, or \code{paul}. Default is \code{morlet}.
Significance testing is only available for \code{morlet} wavelet.}

\item{sig.level}{significance level to compute. Default is \code{0.95}}

\item{quiet}{Do not display progress bar. Default is \code{FALSE}}
}
\description{
Equivalent to \code{wtc.sig}
}
\examples{
# Not run: library(foreach)
# library(doParallel)
# cl <- makeCluster(4, outfile="") # number of cores. Notice 'outfile'
# registerDoParallel(cl)
# wtc_sig_parallel(your parameters go here)
# stopCluster(cl)

}

