% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Summary.bm_list.R
\name{Summary.bm_list}
\alias{Summary.bm_list}
\title{max, min, and range for bitmap objects}
\usage{
\method{Summary}{bm_list}(..., na.rm = FALSE)
}
\arguments{
\item{...}{Passed to relevant functions.}

\item{na.rm}{Passed to \code{min()} and \code{max()}.}
}
\value{
An integer vector.
}
\description{
\code{max()}, \code{min()}, and \code{range()} will provide the  maximum and minimum
integer values found in the \code{bm_bitmap()}, \code{bm_list()}, or \code{bm_list()} objects.
The other four S3 \link[base:groupGeneric]{base::Summary} methods - \code{all()}, \code{any()}, \code{sum}, and \code{prod} -
are only supported for \code{bm_bitmap()} objects
(which are subclasses of integer matrices).
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  min(font)
  max(font)
  range(font)
}
