% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_compress.R
\name{bm_compress}
\alias{bm_compress}
\title{Compress bitmaps using a "block elements" scheme}
\usage{
bm_compress(bm_object, direction = "vertical")
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{direction}{Either "vertical" or "v", "horizontal" or "h",
OR "both" or "b".}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
Compress bitmaps by a factor of two by re-mapping to a \dQuote{block elements} scheme.
}
\details{
Depending on \code{direction} we shrink the bitmaps height and/or width by
a factor of two and re-encode pairs/quartets of pixels to a \dQuote{block elements} scheme.
If necessary we pad the right/bottom of the bitmap(s) by
a pixel. For each pair/quartet we determine the most-common non-zero element
and map them to a length twenty set of integers representing the \dQuote{block
elements} scheme.  For integers greater than zero we map it to higher twenty
character sets i.e. \code{1}'s get mapped to 0:19, \code{2}'s get mapped to 20:39, \code{3}'s
get mapped to 40:59, etc.  Using the default \code{px_unicode} will give you the exact
matching \dQuote{Block Elements} glyphs while \code{px_ascii} gives the closest ASCII approximation.
Hence \code{print.bm_bitmap()} should produce reasonable results for compressed bitmaps if
either of them are used as the \code{px} argument.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  r <- font[[str2ucp("R")]]
  print(r, px = px_ascii)
  print(bm_compress(r, "vertical"), px = px_ascii)
  print(bm_compress(r, "horizontal"), px = px_ascii)
  print(bm_compress(r, "both"), px = px_ascii)
}
\seealso{
See \url{https://en.wikipedia.org/wiki/Block_Elements} for more info on the Unicode Block Elements block.
}
