% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_flip.R
\name{bm_flip}
\alias{bm_flip}
\title{Flip (reflect) bitmaps}
\usage{
bm_flip(bm_object, direction = "vertical", in_place = FALSE)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{direction}{Either "vertical" or "v", "horizontal" or "h",
OR "both" or "b".}

\item{in_place}{If \code{TRUE} flip the glyphs in place (without changing any white space padding).}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_flip()} flips (reflects) bitmaps horizontally, vertically, or both.
It can flip the entire bitmap or just the glyph in place.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)

  # Print upside down
  bml <- as_bm_list("RSTATS", font = font)
  bml <- bm_flip(bml, "both")
  bm <- bm_call(bml, cbind, direction = "RTL")
  print(bm, px = px_ascii)

  # Can also modify glyphs "in place"
  exclamation <- font[[str2ucp("!")]]
  exclamation_flipped <- bm_flip(exclamation, in_place = TRUE)
  print(exclamation_flipped, px = px_ascii)
}
