% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{birp_data_from_file}
\alias{birp_data_from_file}
\title{Create a birp_data Object from File(s)}
\usage{
birp_data_from_file(filenames, method_names = NA, sep = ",")
}
\arguments{
\item{filenames}{A character vector of file paths. Each file must contain a data frame with the columns 'timepoint', 'location', 'counts', 'effort' and 'CI_group'.}

\item{method_names}{Optional vector of method names corresponding to the input files. If not provided, names are inferred from the file names.}

\item{sep}{The field separator used in the files (default is comma).}
}
\value{
An object of type \link{birp_data}
}
\description{
Constructs a 'birp_data' object from one or more input files, each representing data for a different method.
}
\examples{
dir <- system.file("extdata", package = "birp")
filenames <- file.path(dir, "birp_Method_1_simulated_counts.txt")
data <- birp_data_from_file(filenames = filenames, sep = "\t")
}
