% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_stat.R
\encoding{UTF-8}
\name{summ_stat}
\alias{summ_stat}
\title{Pooled Summary Descriptive Statistics}
\usage{
summ_stat(mean, n, var, sd, se)
}
\arguments{
\item{mean}{numeric. A vector of mean values to be pooled.}

\item{n}{numeric. A vector of n values to be pooled.}

\item{var}{numeric. A vector of variance values to be pooled.}

\item{sd}{numeric. A vector of standard deviation values to be pooled.}

\item{se}{numeric. A vector of standard error of the mean vlaues to be pooled.}
}
\description{
Pools summary statistics when given mean and (optionally) a measurement of variability (choose one among \code{var}, \code{sd}, and \code{se}).
}
\examples{
summ_stat(mean = c(0.68, 0.67), n = c(4, 5), sd = c(0.11, 0.15))
summ_stat(mean = 0.68, n = 3, se = 5)
summ_stat(mean = rnorm(1e4), n = rep(1, 1e4)) # Find pooled mean when variability is unknown.

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\seealso{
\code{\link{weighted.mean}}, \code{\link{se}}
}

