% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesthetics.R
\name{axes}
\alias{axes}
\title{Format aesthetics for the biplot axes}
\usage{
axes(bp, X.names=colnames(bp$X), which = 1:bp$p, col = grey(0.7), lwd = 1, lty = 1,
label.dir = "Orthog", label.col = col, label.cex = 0.75, label.line = 0.1, 
label.offset=rep(0,4), ticks = 5, tick.col = col, tick.size = 1, tick.label = TRUE, 
tick.label.side = "below", tick.label.col = tick.col, tick.label.cex = 0.6,
predict.col = col, predict.lwd = lwd, predict.lty = lty, ax.names = X.names,
orthogx = 0, orthogy = 0, vectors = FALSE, unit.circle=FALSE)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{X.names}{a vector of column names of \code{bp} to specify which axes should be labelled.}

\item{which}{a vector containing the columns or variables for which the axes should be displayed, with default \code{1:p}.}

\item{col}{the colour(s) for the axes, with default \code{grey(0.7)}. Alternatively, provide a vector of colours corresponding to \code{X.names}.}

\item{lwd}{the line width(s) for the axes, with default \code{1}.}

\item{lty}{the line type(s) for the axes, with default \code{1}.}

\item{label.dir}{a character string indicating the placement of the axis titles to the side of the figure. One of "\code{Orthog}" for axis titles to appear orthogonal to the side of the figure (default) , "\code{Hor}" for axis titles to appear horizontally or "\code{Paral}" for axis titles to appear parallel to the side of the figure.}

\item{label.col}{the colour(s) for the axis labels, with default, \code{col}.}

\item{label.cex}{the label expansion for the axis labels, with default \code{0.75}.}

\item{label.line}{the distance of the axis title from the side of the figure, with default \code{0.1}.}

\item{label.offset}{a four-component numeric vector controlling the distances axis titles are displayed from the side of the figure, with default \code{rep(0,4)}. Sides are numbered \code{1} to \code{4} according to \code{R} conventions.}

\item{ticks}{an integer-valued vector indicating the number of tickmarks for each axis, with default \code{5} for each axis.}

\item{tick.col}{the colour(s) for the tick marks, with default \code{col}.}

\item{tick.size}{a vector specifying the sizes of tick marks for each axis, with default \code{1} for each .}

\item{tick.label}{a logical value indicating whether the axes should be labelled, with default \code{TRUE}.}

\item{tick.label.side}{a character string indicating the position of the tick label. One of "\code{below}" for the label to appear below the tick mark (default) or "\code{above}" for the label to appear above the tick mark.}

\item{tick.label.col}{the colour(s) for the tick mark labels, with default \code{tick.col}.}

\item{tick.label.cex}{the label expansion for the tick mark labels, with default \code{0.6}.}

\item{predict.col}{the colour(s) for the predicted samples, with default \code{col}.}

\item{predict.lwd}{the line width(s) for the predicted samples, with default \code{lwd}.}

\item{predict.lty}{the line type(s) for the predicted samples, with default \code{lty}.}

\item{ax.names}{a vector of size \code{p} containing user defined titles for the axes.}

\item{orthogx}{a numeric vector of size \code{p} specifying the x-coordinate of the parallel transformation of each axis, with default \code{0} for each axis. This is only used when \code{dim.biplot = 2}.}

\item{orthogy}{a numeric vector of size \code{p} specifying the y-coordinate of the parallel transformation of each axis, with default \code{0} for each axis. This is only used when \code{dim.biplot = 2}.}

\item{vectors}{a logical value indicating whether vector representation (calibrated axes) should be displayed on the biplot. This is only used when a PCA biplot is produced.}

\item{unit.circle}{a logical value indicating whether a unit circle should be displayed on the biplot.}
}
\value{
The object of class \code{biplot} will be appended with a list called \code{axes} containing the following elements:
\item{which}{a vector containing the columns for which the axes are displayed.}
\item{col}{the colour(s) of the axes.}
\item{lwd}{the line width(s) of the axes.}
\item{lty}{the line type(s) of the axes.}
\item{label.dir}{the placement of the axis titles to the side of the figure.}
\item{label.col}{the colour(s) of the axis titles.}
\item{label.cex}{the label expansion(s) of the axis titles.}
\item{label.line}{the distance(s) of the axis titles from the side of the figure.}
\item{ticks}{the number of tick marks per axis.}
\item{tick.col}{the colour(s) of the tick marks.}
\item{tick.size}{the size(s) of the tick marks.}
\item{tick.label}{logical value(s) indicating whether axes are labelled.}
\item{tick.label.side}{the position of the tick mark labels.}
\item{tick.label.col}{the colour(s) of the tick mark labels.}
\item{tick.label.cex}{the expansion(s) of the tick mark labels.}
\item{predict.col}{the colour(s) of the predicted samples.}
\item{predict.lty}{the line type(s) of the predicted samples.}
\item{predict.lwd}{the line width(s) of the predicted samples.}
\item{names}{the user defined axis titles.}
\item{orthogx}{the horizontal translations for each axis.}
\item{orthogy}{the vertical translations for each axis.}
\item{vectors}{a logical value indicating whether calibrated axes are plotted.}
}
\description{
This function allows the user to format the aesthetics for the biplot axes.
}
\examples{
biplot(iris[,1:4]) |> PCA() |> axes(col="purple") |> plot()
biplot(iris[,1:4]) |> PCA() |> samples(col="purple",pch=15) |> axes() |> plot()

}
\seealso{
\code{\link[=biplot]{biplot()}}
}
