% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calc_factor_prefix}
\alias{calc_factor_prefix}
\title{Get a factor to convert metric prefixes.}
\usage{
calc_factor_prefix(from, to)
}
\arguments{
\item{from}{A string containing the prefixed unit A.}

\item{to}{A string containing the prefixed unit B.}
}
\value{
A factor for multiplication with the value.
}
\description{
Get a factor to convert metric prefixes into one another.
}
\details{
Convert, e.g. "kg" to "µg". You can convert ".g", ".l", ".mol", ".M", ".m^3"
(cubic metres), where "." symbolises a metric prefix:

For g, l, mol and M: m (milli), µ (micro), n (nano), p (pico) and f (femto).

For g you might use k (kilo) as well.

For m^3 (cubic metres): d (deci), c (centi) and m (milli)

"." symbolises a metric prefix:

For g, l, mol and M: m (milli), µ (micro), n (nano), p (pico) and f (femto).

For g you might use k (kilo) as well.

For m^3 (cubic metres): d (deci), c (centi) and m (milli)
}
\examples{
calc_factor_prefix(from = "ng", to = "kg")
calc_factor_prefix(from = "dm^3", to = "cm^3")
calc_factor_prefix(from = "fl", to = "pl")
calc_factor_prefix(from = "pmol", to = "nmol")
calc_factor_prefix(from = "pM", to = "nM")

}
\seealso{
Other conversion functions: \code{\link{calc_factor_conc}},
  \code{\link{convert_conc}}, \code{\link{convert_prefix}}
}
