% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{hasQualif}
\alias{hasQualif}
\alias{hasQualif,gbFeature-method}
\alias{hasQualif,gbFeatureTable-method}
\alias{hasQualif,gbRecord-method}
\alias{hasQualif,gbRecordList-method}
\title{Has a feature a specific qualifier?}
\usage{
hasQualif(x, qualifier, ...)

\S4method{hasQualif}{gbFeature}(x, qualifier)

\S4method{hasQualif}{gbFeatureTable}(x, qualifier)

\S4method{hasQualif}{gbRecord}(x, qualifier)

\S4method{hasQualif}{gbRecordList}(x, qualifier)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} object.}

\item{qualifier}{A character string. Name of a qualifier.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A logical vector or a list of logical vectors.
}
\description{
Has a feature a specific qualifier?
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
hasQualif(x, 'CDS')
}
\seealso{
\code{\link{qualifList}}, to extract a list of available qualifiers for
 each feature; \code{\link{uniqueQualifs}}, for a vector of all
 unique qualifiers present in an object.
}
