% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R
\docType{methods}
\name{dbxref}
\alias{dbxref}
\alias{dbxref,gbFeature-method}
\alias{dbxref,gbFeatureTable-method}
\alias{dbxref,gbRecord-method}
\title{Access the \code{db_xref}s of GenBank features}
\usage{
dbxref(x, db = NULL, ...)

\S4method{dbxref}{gbFeature}(x, db = NULL, ...)

\S4method{dbxref}{gbFeatureTable}(x, db = NULL, ...)

\S4method{dbxref}{gbRecord}(x, db = NULL, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}}, or
\code{\linkS4class{gbRecord}} object.}

\item{db}{(Optional) A character vector giving the database names of the
desired \code{db_xref}s.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A named character vector (or list of named character vectors)
of db_xrefs.
}
\description{
Access the \code{db_xref}s of GenBank features
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))

## all db_xrefs associated with CDSs
dbxref(x["CDS"])

## retrieve the TaxId from the "source" field.
dbxref(x[[1]], "taxon")
}
