% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_estimation.R
\name{estimate_whole_body_merkle}
\alias{estimate_whole_body_merkle}
\title{Whole-body dose estimation (Merkle's method)}
\usage{
estimate_whole_body_merkle(
  num_cases,
  case_data,
  fit_coeffs,
  fit_var_cov_mat,
  conf_int_yield = 0.83,
  conf_int_curve = 0.83,
  protracted_g_value = 1,
  genome_factor = 1,
  aberr_module = c("dicentrics", "translocations", "micronuclei")
)
}
\arguments{
\item{num_cases}{number of cases.}

\item{case_data}{Case data in data frame form.}

\item{fit_coeffs}{Fitting coefficients matrix.}

\item{fit_var_cov_mat}{Fitting variance-covariance matrix.}

\item{conf_int_yield}{Confidence interval of the yield, 83\% by default.}

\item{conf_int_curve}{Confidence interval of the curve, 83\% by default.}

\item{protracted_g_value}{Protracted \eqn{G(x)} value.}

\item{genome_factor}{Genomic conversion factor used in translocations, else 1.}

\item{aberr_module}{Aberration module.}
}
\value{
List containing estimated doses data frame, AIC, and \code{conf_int_*} used.
}
\description{
Method based on the paper by Merkle, W. (1983). Statistical methods in
regression and calibration analysis of chromosome aberration data. Radiation
and Environmental Biophysics, 21(3), 217-233. <doi:10.1007/BF01323412>.
}
\examples{
#The fitting RDS result from the fitting module is needed. Alternatively, manual data
#frames that match the structure of the RDS can be used:
fit_coeffs <- data.frame(
  estimate   = c(0.001280319, 0.021038724, 0.063032534),
  std.error  = c(0.0004714055, 0.0051576170, 0.0040073856),
  statistic  = c(2.715961, 4.079156, 15.729091),
  p.value    = c(6.608367e-03, 4.519949e-05, 9.557291e-56),
  row.names =  c("coeff_C", "coeff_alpha", "coeff_beta")
)


fit_var_cov_mat <- data.frame(
  coeff_C      = c(2.222231e-07, -9.949044e-07,  4.379944e-07),
  coeff_alpha  = c(-9.949044e-07, 2.660101e-05, -1.510494e-05),
  coeff_beta   = c(4.379944e-07, -1.510494e-05, 1.605914e-05),
  row.names =  c("coeff_C", "coeff_alpha", "coeff_beta")
)


case_data <- data.frame(
  ID= "example1",
  N = 361,
  X = 100,
  C0 = 302,
  C1 = 28,
  C2 = 22,
  C3 = 8,
  C4 = 1,
  C5 = 0,
  y = 0.277,
  y_err = 0.0368,
  DI = 1.77,
  u = 10.4
)

#FUNCTION ESTIMATE_WHOLE_BODY_MERKLE
estimate_whole_body_merkle(
  num_cases = 1,
  case_data = case_data,
  fit_coeffs = as.matrix(fit_coeffs),
  fit_var_cov_mat = as.matrix(fit_var_cov_mat),
  conf_int_yield = 0.83,
  conf_int_curve = 0.83,
  protracted_g_value = 1,
  aberr_module = "dicentrics"
)
}
