% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-schema.R
\name{validate_schema_v1.3.0}
\alias{validate_schema_v1.3.0}
\alias{validate_schema}
\title{BioCompute Objects schema validator (v1.3.0)}
\usage{
validate_schema_v1.3.0(file)

validate_schema(file)
}
\arguments{
\item{file}{Path to the BCO JSON file}
}
\value{
None
}
\description{
BioCompute Objects schema validator (v1.3.0)
}
\note{
JSON schema validators for BCO domains and complete BCO based on
jsonvalidate. Refer to the
\href{https://github.com/biocompute-objects/BCO_Specification/tree/main/ieee-2791-schema}{BioCompute Objects Schema}
for specific JSON schemas.
}
\examples{
bco <- tempfile(fileext = ".json")
generate_example("HCV1a") \%>\%
  convert_json() \%>\%
  export_json(bco)
bco \%>\% validate_schema()
}
