% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_night.R
\name{check_night}
\alias{check_night}
\alias{check_night.default}
\alias{check_night.vp}
\alias{check_night.list}
\alias{check_night.vpts}
\alias{check_night.vpi}
\alias{check_night.pvol}
\title{Check if it is night at a given time and place}
\usage{
check_night(x, ..., elev = -0.268, offset = 0)

\method{check_night}{default}(x, lon, lat, ..., tz = "UTC", elev = -0.268, offset = 0)

\method{check_night}{vp}(x, ..., elev = -0.268, offset = 0)

\method{check_night}{list}(x, ..., elev = -0.268, offset = 0)

\method{check_night}{vpts}(x, ..., elev = -0.268, offset = 0)

\method{check_night}{vpi}(x, ..., elev = -0.268, offset = 0)

\method{check_night}{pvol}(x, ..., elev = -0.268, offset = 0)
}
\arguments{
\item{x}{A \code{pvol}, \code{vp}, \code{vpts}, \code{vpi} object, a POSIXct date or a string
interpretable by \code{\link[base:as.POSIXlt]{base::as.POSIXct()}}.}

\item{...}{Optional lat, lon arguments.}

\item{elev}{Numeric (vector). Sun elevation in degrees defining nighttime.
May also be a numeric vector of length two, with first element giving
sunset elevation, and second element sunrise elevation.}

\item{offset}{Numeric (vector). Time duration in seconds by which to shift
the start and end of nighttime. May also be a numeric vector of length two,
with first element added to moment of sunset and second element added to
moment of sunrise.}

\item{lon}{Numeric. Longitude, in decimal degrees.}

\item{lat}{Numeric. Latitude, in decimal degrees.}

\item{tz}{Character. Time zone. Ignored when \code{date} already has an associated
time zone.}
}
\value{
\code{TRUE} when night, \code{FALSE} when day, \code{NA} if unknown
(either datetime or geographic location missing). For \code{vpts} a
vector of \code{TRUE}/\code{FALSE} values is returned.
}
\description{
Checks if it is night (\code{TRUE}/\code{FALSE}) for a combination of
latitude, longitude, date and sun elevation. When used on a bioRad object
(\code{pvol}, \code{vp}, \code{vpts}, \code{vpi}) this information is extracted from the
bioRad object directly.
}
\details{
\code{check_night()} evaluates to \code{FALSE} when the sun has a higher
elevation than parameter \code{elev}, otherwise \code{TRUE}.

Approximate astronomical formula are used, therefore the day/night
transition may be off by a few minutes.

The angular diameter of the sun is about 0.536 degrees, therefore the moment
of sunrise/sunset corresponds to half that elevation at -0.268 degrees.
Approximate astronomical formula are used, therefore the day/night transition
may be off by a few minutes.

\code{offset} can be used to shift the moment of sunset and sunrise by a temporal
offset, for example, \code{offset = c(600,-900)} will assume nighttime starts 600
seconds after sunset (as defined by \code{elev}) and stops 900 seconds before
sunrise.
}
\examples{
# Check if it is night at UTC midnight in the Netherlands on January 1st:
check_night("2016-01-01 00:00", 5, 53)

# Check on bioRad objects directly:
check_night(example_vp)

check_night(example_vpts)

# Select nighttime profiles that are between 3 hours after sunset
# and 2 hours before sunrise:
index <- check_night(example_vpts, offset = c(3,-2)*3600)
example_vpts[index]
}
