% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi.R
\name{[.ppi}
\alias{[.ppi}
\title{Subset a plan position indicator (\code{ppi})}
\usage{
\method{[}{ppi}(x, i)
}
\arguments{
\item{x}{A \code{ppi} object.}

\item{i}{Integer. Index/indices specifying which parameters (\code{param}) or
derived quantities to extract.}
}
\value{
A \code{ppi} object containing a subset of parameters (\code{param}).
}
\description{
Select parameters (\code{param}) or derived quantities by index from a plan
position indicator (\code{ppi}).
}
\examples{
# Project a scan as a ppi
ppi <- project_as_ppi(example_scan)

# This ppi contains 5 parameters (DBZH VRADH ZDR RHOHV PHIDP)
ppi

# Subset ppi to one containing only the first parameter (DBZH)
ppi[1]

# Subset ppi to one containing the first three parameters (DBZH, VRADH, ZDR)
ppi[1:3]

# Subset ppi to one without the first 2 parameters (ZDR RHOHV PHIDP)
ppi[-1:-2]
}
