% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_legacy.R
\name{convert_legacy}
\alias{convert_legacy}
\alias{convert_legacy.vp}
\alias{convert_legacy.vpts}
\title{Convert legacy bioRad objects}
\usage{
convert_legacy(x)

\method{convert_legacy}{vp}(x)

\method{convert_legacy}{vpts}(x)
}
\arguments{
\item{x}{A \code{vp} or \code{vpts} object.}
}
\value{
An updated object of the same class as the input.
}
\description{
Convert legacy bioRad objects (\code{vp}, \code{vpts}) and make them compatible with
the current bioRad version. Conversion includes renaming \code{HGHT} to \code{height}.
}
\examples{
# Convert a vp object
vp <- convert_legacy(example_vp)

# Convert a vpts object
vpts <- convert_legacy(example_vpts)
}
\seealso{
\itemize{
\item \code{\link[=summary.vp]{summary.vp()}}
\item \code{\link[=summary.vpts]{summary.vpts()}}
}
}
