% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_vvp_threshold.R
\name{sd_vvp_threshold}
\alias{sd_vvp_threshold}
\alias{sd_vvp_threshold.vp}
\alias{sd_vvp_threshold.list}
\alias{sd_vvp_threshold.vpts}
\title{Get threshold of the radial velocity standard deviation}
\usage{
sd_vvp_threshold(x)

\method{sd_vvp_threshold}{vp}(x)

\method{sd_vvp_threshold}{list}(x)

\method{sd_vvp_threshold}{vpts}(x)
}
\arguments{
\item{x}{A \code{vp}, list of \code{vp} or \code{vpts} object.}
}
\value{
The \code{sd_vvp} threshold in m/s.
}
\description{
Returns the current threshold of the radial velocity standard deviation
(\code{sd_vvp}) of an object in m/s, retrieved by velocity volume processing
(VVP).
}
\examples{
# Get the sd_vvp threshold for a vp
sd_vvp_threshold(example_vp)

# Get the sd_vvp threshold for a vpts
sd_vvp_threshold(example_vpts)
}
\seealso{
\itemize{
\item \code{\link[=sd_vvp_threshold<-]{sd_vvp_threshold()<-}} for setting the \code{sd_vvp}
threshold of an object.
\item \code{\link[=rcs]{rcs()}}
}
}
