% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvol.R
\name{summary.pvol}
\alias{summary.pvol}
\alias{is.pvol}
\title{Class \code{pvol}: a polar volume}
\usage{
\method{summary}{pvol}(object, ...)

is.pvol(x)
}
\arguments{
\item{object}{Object of class \code{pvol}.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{Object of class \code{pvol}.}
}
\value{
for \code{is.pvol}: \code{TRUE} if its argument is of
class \code{pvol}
}
\description{
Class \code{pvol} for a polar volume, and its associated R base functions.
}
\details{
An object of class \code{pvol} is a list containing:
\describe{
 \item{\code{radar}}{character string with the radar identifier}
 \item{\code{datetime}}{nominal time of the volume [UTC]}
 \item{\code{scans}}{a list with scan objects of class 'scan'}
 \item{\code{attributes}}{list with the volume's \code{\\what},
   \code{\\where} and \code{\\how} attributes}
 \item{\code{geo}}{geographic data, a list with:
  \describe{
     \item{\code{lat}}{latitude of the radar [decimal degrees]}
     \item{\code{lon}}{longitude of the radar [decimal degrees]}
     \item{\code{height}}{height of the radar
       antenna [meters above sea level]}
  }
 }
}
}
\examples{
# locate example volume file:
pvol <- system.file("extdata", "volume.h5", package = "bioRad")
# print the local path of the volume file:
pvol
# load the file:
vol <- read_pvolfile(pvol)
# print summary info for the loaded polar volume:
vol
# print summary info for the scans in the polar volume:
vol$scans
# copy the first scan to a new object 'scan'
scan <- vol$scans[[1]]
is.pvol("this is not a polar volume but a string") # > FALSE
}
