% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvolfile.R
\name{is.pvolfile}
\alias{is.pvolfile}
\title{Check if a local file is a polar volume (\code{pvol})}
\usage{
is.pvolfile(file, filename = NULL)
}
\arguments{
\item{file}{A string containing a file name.}

\item{filename}{Deprecated argument, use file instead.}
}
\value{
TRUE when \code{file} is a polar volume in readable format,
otherwise FALSE
}
\description{
Checker whether a file is a polar volume that can be read with
package \pkg{bioRad}
}
\examples{
volume <- system.file("extdata", "volume.h5", package = "bioRad")
is.pvolfile(volume) # > TRUE
}
