% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scan.R
\name{get_scan}
\alias{get_scan}
\title{Get a scan (\code{scan}) from a polar volume (\code{pvol})}
\usage{
get_scan(x, elev)
}
\arguments{
\item{x}{An object of class \code{pvol}.}

\item{elev}{Elevation angle.}
}
\value{
An object of class '\link[=summary.scan]{scan}'.
}
\description{
Get a scan (\code{scan}) from a polar volume (\code{pvol})
}
\details{
The function returns the scan with elevation angle closest
to \code{elev}.
}
\examples{
# locate example volume file:
pvol <- system.file("extdata", "volume.h5", package = "bioRad")
# load the file:
vol <- read_pvolfile(pvol)
# extract the scan at 3 degree elevation:
myscan <- get_scan(vol, 3)
}
