% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beam.R
\name{beam_range}
\alias{beam_range}
\title{Calculate radar beam range}
\usage{
beam_range(distance, elev, k = 4/3, lat = 35, re = 6378, rp = 6357)
}
\arguments{
\item{distance}{Numeric. Distance from the radar as measured along sea level
(down range), in m.}

\item{elev}{Numeric. Beam elevation, in degrees.}

\item{k}{Numeric. Standard refraction coefficient.}

\item{lat}{Numeric. Geodetic latitude of the radar, in degrees.}

\item{re}{Numeric. Earth equatorial radius, in km.}

\item{rp}{Numeric. Earth polar radius, in km.}
}
\value{
Beam range (slant range), in m.
}
\description{
Calculates the range (i.e. slant range) given a distance measured along the
earth's surface (i.e. down range) and beam elevation.
}
\details{
depends on \link{beam_height} to calculate beam height.
}
\examples{
# Slant range of the 5 degree elevation beam at a down range of 100 km
beam_range(100000, 5)
}
\seealso{
Other beam_functions: 
\code{\link{beam_distance}()},
\code{\link{beam_height}()},
\code{\link{beam_profile}()},
\code{\link{beam_profile_overlap}()},
\code{\link{beam_width}()},
\code{\link{gaussian_beam_profile}()}
}
\concept{beam_functions}
